﻿Add-Type -AssemblyName System.Drawing

# Create a bitmap to capture the entire virtual screen (all monitors)
$virtualScreenWidth = [System.Windows.Forms.SystemInformation]::VirtualScreen.Width
$virtualScreenHeight = [System.Windows.Forms.SystemInformation]::VirtualScreen.Height
$virtualScreenLeft = [System.Windows.Forms.SystemInformation]::VirtualScreen.Left
$virtualScreenTop = [System.Windows.Forms.SystemInformation]::VirtualScreen.Top

$bitmap = New-Object System.Drawing.Bitmap $virtualScreenWidth, $virtualScreenHeight
$graphics = [System.Drawing.Graphics]::FromImage($bitmap)

# Capture the screen
$graphics.CopyFromScreen($virtualScreenLeft, $virtualScreenTop, 0, 0, $bitmap.Size)

# Save the screenshot to a file
$outputPath = "$env:USERPROFILE\Desktop\Screenshot.png"
$bitmap.Save($outputPath, [System.Drawing.Imaging.ImageFormat]::Png)

# Clean up
$graphics.Dispose()
$bitmap.Dispose()

Write-Host "Screenshot saved to $outputPath"
